#########################################################################
#	file: 		csv.t						#
#	description:	makes a csv file with the selected invoices	#
#	date:		301003						#
#	modified:	160307						#
#	Written By:	Mads Linden					#
#	(C) Copyright 1999 by The Electronic Farm Sweden.					#
#	(C) Copyright 2007 by Farmers Wife S.L..							#
#	version:	0.2 (wife 46,0,1)				#
#########################################################################

## See the readme.txt file for documentation.

# define the separator character
set SEP $::LOCALE_LIST
# define the currency decimal separator
set money_sep $::LOCALE_DECIMAL

# open a new file, using the session id for a unique name
set fileid [open [file join $::SYSTEM_PATH tmp_files $SESSION.csv] w]
# mac roman characters
if {$::PLATFORM == 3} {
	fconfigure $fileid -translation binary -encoding MacRoman
} else {
	fconfigure $fileid -translation binary
}

proc toMoney {value} {
	global money_sep
	
	set int [string range $value 0 end-2]
	set dec [string range $value end-1 end]
	set value "${int}${money_sep}${dec}"
	return $value
}

# start the loop on each selected invoice
foreach invoice $INVOICES_SELECTED customs $INVOICES_SELECTED_CUSTOMS {
	lset invoice 16 [toMoney [lindex $invoice 16]]
	lset invoice 17 [toMoney [lindex $invoice 17]]
	lset invoice 18 [toMoney [lindex $invoice 18]]
	
	# Due Date
	lset invoice 23 [lindex [wife::send intday_to_dateformat [lindex $invoice 23]] 1]
	# Creation Date
	lset invoice 28 [lindex [wife::send intday_to_dateformat [lindex $invoice 28]] 1]
	# Paid Date
	lset invoice 38 [lindex [wife::send intday_to_dateformat [lindex $invoice 38]] 1]
	
	puts $fileid \"[join [lreplace $invoice 21 21] \042${SEP}\042]\"
}

# close the file
close $fileid

# start excel
if {[catch {
	eval exec [auto_execok start] \"\" \"[file join $::SYSTEM_PATH tmp_files $SESSION.csv]\" &
} R1]} {
	# we could be on a mac
	exec open "[file join $::SYSTEM_PATH tmp_files $SESSION.csv]"
}

# shut down this script
wife::send exit $SESSION


